import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;

public class PollServlet extends HttpServlet {

	private int football = 0;
	private int basketball = 0;
	private int volleyball = 0;
	
	public void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
				
		response.setContentType("text/html");
		PrintWriter out = response.getWriter();
		if(request.getParameter("see")!=null) {
			viewPoll(out);
			return;
		}
		
		boolean f = request.getParameter("f")!=null;
		boolean b = request.getParameter("b")!=null;
		boolean v = request.getParameter("v")!=null;
		
		poll(f, b, v);
		viewPoll(out);
	}
	
	private synchronized void poll(boolean f, boolean b, boolean v) {
		if(f) football++;
		if(b) basketball++;
		if(v) volleyball++;
	}
	
	private synchronized void viewPoll(PrintWriter out) {
		out.println("football: "+football+ "<br>basketball: "+basketball+ "<br>volleyball: "+volleyball);
	}
	
	public void doPost(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		doGet(request, response);
	}
}